#pragma rtGlobals=1		// Use modern global access method.

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												ANGLE - ENERGY
//-------------------------------------------------------------------------------------------------------------------------------------------------------------    
Proc AngleEnergy(particle)
	String particle
	
	variable WaveSize
	WaveSize=numpnts($("x_"+particle))

	make/O/D/N=(Wavesize) $("thet_"+particle),$("phi_"+particle),$("dvthet_"+particle),$("dvphi_"+particle)
	make/O/D/N=(Wavesize) $("Etrans_"+particle),$("Elong_"+particle),$("E_"+particle)
	
	// Angle
	$("thet_"+particle)=atan2(sqrt($("py_"+particle)^2+$("pz_"+particle)^2),$("px_"+particle))
	$("phi_"+particle)=atan2($("pz_"+particle),$("py_"+particle))	
	$("dvthet_"+particle)=atan2(sqrt($("px_"+particle)^2+$("py_"+particle)^2), $("pz_"+particle) )
	$("dvphi_"+particle)=atan2($("py_"+particle),$("px_"+particle))	
	
	// Energy
	$("Etrans_"+particle)=($("px_"+particle)^2+$("py_"+particle)^2)/1000
	$("Elong_"+particle)=($("pz_"+particle)^2)/1000
	$("E_"+particle)= ($("Etrans_"+particle))+($("Elong_"+particle))

	Histo_AngleEnergy(particle, "w_e",0,10,400)    
End

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												CORRELATION
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  
Proc Correlation(particle1,particle2)
	String particle1,particle2
	
	variable WaveSize
	WaveSize=numpnts($("x_"+particle1))
	make/O/D/N=(Wavesize) $("Dphi_"+particle1+particle2),$("Dthet_"+particle1+particle2)
	make/O/D/N=(Wavesize) $("thet_"+particle1+particle2),$("Etot_"+particle1+particle2)

	$("Dphi_"+particle1+particle2)=$("phi_"+particle1)-$("phi_"+particle2)
	$("Dthet_"+particle1+particle2)=$("thet_"+particle1)-$("thet_"+particle2)
	
	thet12($("px_"+particle1),$("py_"+particle1),$("pz_"+particle1),$("px_"+particle2),$("py_"+particle2),$("pz_"+particle2),$("thet_"+particle1+particle2))
	$("Etot_"+particle1+particle2)=($("E_"+particle1))+($("E_"+particle2))

	Histo_Correlation(particle1,particle2, "",5,5,5,5,200)
End

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												MUTUAL ANGLE
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  
function thet12(px1,py1,pz1,px2,py2,pz2,w)
	wave px1,py1,pz1,px2,py2,pz2,w
	w= acos((px1*px2+py1*py2+pz1*pz2)/(sqrt((px1^2+py1^2+pz1^2)*(px2^2+py2^2+pz2^2))))
end

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												ROTATION
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  

function rotation (particle, xg,yg, theta)
string particle
variable xg,yg,theta
wave x=$("x_"+particle)
wave y=$("y_"+particle)
variable costheta, sintheta
theta=theta/180*Pi
costheta=cos(theta)
sintheta=sin(theta)
x=(x-xg)*costheta+(y-yg)*sintheta
y=-(x-xg)*sintheta+(y-yg)*costheta

end
